<?php
/**
 * The default index page template.
 * @package ninja
 */

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<?php
		if ( have_posts() ) :

			if ( is_home() && ! is_front_page() ){ ?>
				<header>
					<h1 class="page-title"><?php single_post_title(); ?></h1>
				</header>

			<?php } ?>

			<div id="container">

			<?php while ( have_posts() ) : the_post(); ?>
			
				<?php 
		          if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		            $thumb_id = get_post_thumbnail_id();
		            $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'full', true);
		            $thumb_url = $thumb_url_array[0];
		            echo '<div class="page-featured-banner" style="background-image:url('.$thumb_url.')">
		            <div class="container"><h1>'.get_the_title().'</h1></div></div>';
		          } 
		        ?>
				<div class="content">
					<?php the_content(); ?>
				</div><!-- .content -->

		  <?php endwhile; ?>

		  </div><!-- #container -->

		<?php do_action('ninja_navigation');

		endif; ?>

	</main><!-- #main -->
</div><!-- #primary -->
<?php get_footer(); ?>
